# 🚀 MikhMon WhatsApp Gateway

Self-hosted WhatsApp Gateway menggunakan Baileys untuk MikhMon.

## ⚡ Quick Start

### Windows:
```bash
install.bat
```

### Linux/macOS:
```bash
chmod +x install.sh
./install.sh
```

### Manual:
```bash
npm install
cp .env.example .env
# Edit .env file
npm start
```

## 📖 Dokumentasi Lengkap

Lihat file: `../WHATSAPP_SELFHOSTED_GUIDE.md`

## 🔧 Commands

### Development:
```bash
npm start
```

### Production (PM2):
```bash
npm install -g pm2
npm run pm2
```

### Check Status:
```bash
pm2 status
pm2 logs mikhmon-wa-gateway
```

## 🌐 Endpoints

- **Health Check:** http://localhost:3000/health
- **Status:** http://localhost:3000/api/status
- **QR Code:** http://localhost:3000/api/qr
- **Send Message:** POST http://localhost:3000/api/send

## 🔐 Security

1. Ganti `API_KEY` di file `.env`
2. Update API key yang sama di `mikhmon/include/whatsapp_config.php`
3. Jangan commit file `.env` ke git

## 📊 Admin Panel

Akses via MikhMon:
```
http://localhost/mikhmon/settings/whatsapp_gateway_admin.php
```

## 🐛 Troubleshooting

### Gateway tidak start:
```bash
npm install
npm start
```

### QR Code tidak muncul:
```bash
pm2 restart mikhmon-wa-gateway
```

### Pesan tidak terkirim:
- Cek status: http://localhost:3000/api/status
- Cek logs: `pm2 logs mikhmon-wa-gateway`
- Pastikan API key sama di .env dan whatsapp_config.php

## 📞 Support

- Dokumentasi: `../WHATSAPP_SELFHOSTED_GUIDE.md`
- Issues: Buat issue di repository
- Logs: `pm2 logs mikhmon-wa-gateway`

## 📄 License

GPL-2.0 - Same as MikhMon

---

**Version:** 1.0.0  
**Author:** MikhMon Team
